<?php
class Basket
{
  private $dbo = null;
  function __construct($dbo)
  {
    $this->dbo = $dbo;
    
    //Utworzenie koszyka, jeli to konieczne
    if(!isset($_SESSION['basket'])){
      $_SESSION['basket'] = array();
    }
  }
  
  function add()
  {
    //Sprawdzenie poprawnoci parametru id
    if(!isset($_GET['id'])){
      return FORM_DATA_MISSING;
    }
    if(($id = (int) $_GET['id']) < 1){
      return INVALID_ID;
    }
    
    //Sprawdzenie czy istnieje ksika o podanym id
    $query = "SELECT Cena FROM ksiazki WHERE id=$id";
    if(($cena = $this->dbo->getQuerySingleResult($query)) === false){
      return INVALID_ID;
    }
    
    //Zapisanie identyfikatora ksiki w koszyku
    if(isset($_SESSION['basket'][$id])){
      $_SESSION['basket'][$id]->ile++;
      $_SESSION['basket'][$id]->cena = $cena;
    }
    else{
      $_SESSION['basket'][$id] = new BasketItem($id, $cena, 1);
    }
    return ACTION_OK;
  }
  
  function show($title, $allowModify = true)
  {
    if(count($_SESSION['basket']) == 0){
      $komunikat = 'Koszyk jest pusty.';
    }
    else{
      //Pobranie listy identyfikatorw dla warunku zapytania
      $ids = implode(',', array_keys($_SESSION['basket']));
      
      //Pobranie danych dotyczcych ksiek z koszyka
      $query  = 'SELECT `Id`, `Tytu`, `Cena` FROM Ksiazki '
              . 'WHERE `Id` IN('.$ids.') ORDER BY `Tytu`';
      
      //Tutaj mona sprawdzi czy nie zmianiy si ceny ksiek
      
      if($books = $this->dbo->query($query)){
        $basket = $_SESSION['basket'];
        $komunikat = false;
      }
      else{
        $komunikat = 'Bd serwera. Zawarto koszyka nie jest dostpna.';
      }
    }
    include 'templates/basket.php';
  }
  
  function modify()
  {
    foreach($_SESSION['basket'] as $id => $item){
      if(!isset($_POST[$id])){
        unset($_SESSION['basket'][$id]);
      }
      else if($_POST[$id] < 1){
        unset($_SESSION['basket'][$id]);
      }
      else{
        $item->ile = (int) $_POST[$id];
      }
    }
  }
  
  function saveOrder(&$orderId)
  {
    //Sprawdzenie czy koszyk ma zawarto
    if(count($_SESSION['basket']) < 1){
      return EMPTY_BASKET;
    }
    
    //Sprawdzenie czy uytkownik jest zalogowany
    if(!isset($_SESSION['zalogowany'])){
      return LOGIN_REQUIRED;
    }
    
    //Pobranie identyfikatorw ksiek z koszyka
    $ids = implode(',', array_keys($_SESSION['basket']));
    $userId = $_SESSION['zalogowany']->id;
    
    //Wyczenie automatycznego zatwierdzania transakcji
    $this->dbo->autocommit(false);
    
    //Utworzenie nowego zamwienia
    $query  = 'INSERT INTO Zamowienia '
            . "VALUES(0, $userId, NOW(), NULL, 0)";
    
    if(!$this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    if(($orderId = $this->dbo->insert_id) < 1){
      return SERVER_ERROR;
    }
    
    $query = "INSERT INTO KsiazkiZamowienia VALUES";
    foreach($_SESSION['basket'] as $item){
      $id = $item->id;
      $cena = $item->cena;
      $ile = $item->ile;
      $query .= "($id, $orderId, $ile, $cena),";
    }
    
    $query[strlen($query) - 1] = ' ';
    
    //Jeli nie udao si wykona zapytania
    if(!$this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Jeli liczba dodanych rekordw mniejsza ni 1
    if($this->dbo->affected_rows != count($_SESSION['basket'])){
      return SERVER_ERROR;
    }
    
    //Zatwierdzenie transakcji
    $this->dbo->commit();
    
    //Wyczyszczenie koszyka
    $_SESSION['basket'] = array();
    
    return ACTION_OK;
  }
  
}
?>
